/*
Here's a recap from the Getting Started Tutorial on read live data...

- The callback function calls 'getOutDisplay()'. This function doesn't return the Property's value (that can be accessed by calling 'getOut()') but a display String that's formatted on the Server.
- The code is listening for changed events and when the ORD is resolved.
*/

// First let's resolve an ORD to a writable point...
var sub = new baja.Subscriber();

var update = function () {
  // Note how 'this' refers to the target Component...
  baja.outln("Out: " + this.getOutDisplay());
};

// Attach this function to listen for changed events...
sub.attach("changed", update);

// Resolve and subscribe this Component...
baja.Ord.make("station:|slot:/BajaScriptTutorials/Ramp").get({ok: update, subscriber: sub});
